% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function is performing the numerical inversion of Laplace 
% transformation using the Stehfest algorithm; 
function rt = Stehfest_inv_Lap(funcHandle,time,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,ns)
% ns is the number of terms to be used. Number of terms must be even. 
nh = ns/2; 

v = zeros(ns,1);

% loop over each of vi
for is = 1:ns
    from = floor((is+1)/2); 
    until = min(is, nh); 
    for k = from:until
        v(is,1) = v(is,1) + (k^(ns/2)*factorial(2*k))/(factorial(ns/2-k)*factorial(k)*factorial(k-1)*factorial(is-k)*factorial(2*k-is)); 
    end
    v(is,1) = v(is,1)*(-1)^(ns/2+is); 
end

% calculating inverse of laplace
A = log(2) / time; 
TD = 0.0; 
for i=1:ns
    TD = TD + v(i,1)*feval(funcHandle,i*A,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D);
end
TD = A*TD; 
rt = TD; 



