% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function correspons to T_Dg1(rD,zD,s); Eq.(22) with Eq.(A.30) 
% for B1(zD) and Eq.(A.8) for B2/B1); 
function rt = FG_1(s, N_s, N_g, N_12, H_g, H_f, kappa, A_D1, A_D2, r_Db, r_D, z_D)

numerator = F_1(s,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D)*N_g/(kappa*N_s)*(I_0(r_D*sqrt(H_g*s/kappa))+B2B1(s,H_g,kappa,r_Db)*K_0(r_D*sqrt(H_g*s/kappa)));

denominator = N_g/(kappa*N_s)*(I_0(sqrt(H_g*s/kappa))+B2B1(s,H_g,kappa,r_Db)*K_0(sqrt(H_g*s/kappa))) - sqrt(H_g*s/kappa)*(I_1(sqrt(H_g*s/kappa)) - B2B1(s,H_g,kappa,r_Db)*K_1(sqrt(H_g*s/kappa)));

rt = numerator / denominator; 