% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function is according to Eq. (B.09)
function rt = B4B1(s, H_g, kappa, r_Db)

numerator = kappa*sqrt(H_g*s/kappa)*I_1(r_Db*sqrt(H_g*s/kappa))*K_0(r_Db*sqrt(H_g*s/kappa));
numerator = numerator+kappa*sqrt(H_g*s/kappa)*I_0(r_Db*sqrt(H_g*s/kappa))*K_1(r_Db*sqrt(H_g*s/kappa));

denominator = kappa*sqrt(H_g*s/kappa)*K_1(r_Db*sqrt(H_g*s/kappa))*K_0(r_Db*sqrt(s));
denominator = denominator - sqrt(s)*K_0(r_Db*sqrt(H_g*s/kappa))*K_1(r_Db*sqrt(s)); 

rt = numerator / denominator; 