% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function is according to Eq. (B.7)
function rt = gamma_local(s, N_s, N_g, N_12, H_g, H_f, kappa, A_D1, A_D2, r_Db)

rt = -1.0*(N_s*H_f*A_D1/2*s+N_12+N_g*C0(s,N_s,N_g,H_g,kappa,r_Db))*(N_s*H_f*A_D2/2*s+N_12)+N_12*N_12; 