% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function is according to Eq. (B.11)
function rt = delta_2(s, N_s, N_g, N_12, H_g, H_f, kappa, A_D1, A_D2, r_Db)

rt = (-a2(s,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db) + N_s*H_f/2*A_D2*s + N_12)/N_12; 