% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function is according to Eq. (A.08)
function rt = B2B1(s, H_g, kappa, r_Db)

numerator =  kappa*sqrt(H_g*s/kappa)*I_1(r_Db*sqrt(H_g*s/kappa))*K_0(r_Db*sqrt(s));
numerator = numerator+sqrt(s)*I_0(r_Db*sqrt(H_g*s/kappa))*K_1(r_Db*sqrt(s));

denominator = kappa*sqrt(H_g*s/kappa)*K_1(r_Db*sqrt(H_g*s/kappa))*K_0(r_Db * sqrt(s));
denominator = denominator+(-1)*sqrt(s)*K_0(r_Db*sqrt(H_g*s/kappa))*K_1(r_Db*sqrt(s)); 

rt = numerator ./ denominator; 